/*
 * Decompiled with CFR 0.152.
 */
package com.octagonsoftware.clockease;

import com.octagonsoftware.clockease.Task;
import com.octagonsoftware.clockease.TimeTrackerPanel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class DeleteTaskAction
extends AbstractAction {
    private TimeTrackerPanel _panel;

    public DeleteTaskAction(TimeTrackerPanel panel) {
        super("Delete Task", new ImageIcon(DeleteTaskAction.class.getResource("/com/octagonsoftware/clockease/images/deletetask.png")));
        this._panel = panel;
    }

    public void actionPerformed(ActionEvent e) {
        Task task = this._panel.getSelectedTask();
        if (task != null) {
            String title = task.getTitle();
            if (title == null) {
                title = "";
            }
            if (JOptionPane.showConfirmDialog(this._panel, String.format("Are you sure you wish to delete the task '%s'?", title), "Confirm Delete Task", 0, 3) == 0) {
                this._panel.clearSelection();
                this._panel.getTimeLog().deleteTask(task);
            }
        }
    }

    public boolean isEnabled() {
        return this._panel.getSelectedRowIndex() != -1;
    }
}

