/*
 * Decompiled with CFR 0.152.
 */
package com.octagonsoftware.clockease;

import com.octagonsoftware.clockease.DeleteTimeLogEntryAction;
import com.octagonsoftware.clockease.TimeLog;
import com.octagonsoftware.clockease.TimeLogEntryTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TimeLogEntryPanel
extends JPanel
implements ListSelectionListener {
    private TimeLog _timeLog;
    private TimeLogEntryTableModel _timeLogEntryTableModel = new TimeLogEntryTableModel();
    private DefaultListSelectionModel _selectionModel = new DefaultListSelectionModel();
    private JButton _deleteButton;
    private JScrollPane _scrollPane;
    private JTable _timeLogEntryTable;
    private JToolBar _toolbar;

    public TimeLogEntryPanel() {
        this._selectionModel.setSelectionMode(0);
        this.initComponents();
        this._timeLogEntryTable.getSelectionModel().addListSelectionListener(this);
        this.addActionsToButtons();
        this.updateButtons();
    }

    public void setTimeLog(TimeLog timeLog) {
        this._timeLog = timeLog;
        this._timeLogEntryTableModel.setTimeLog(timeLog);
    }

    public int getSelectedIndex() {
        return this._timeLogEntryTable.getSelectedRow();
    }

    public TimeLog getTimeLog() {
        return this._timeLog;
    }

    public void clearSelection() {
        this._timeLogEntryTable.clearSelection();
    }

    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }

    private void initComponents() {
        this._toolbar = new JToolBar();
        this._deleteButton = new JButton();
        this._scrollPane = new JScrollPane();
        this._timeLogEntryTable = new JTable();
        this.setLayout(new BorderLayout());
        this._toolbar.setFloatable(false);
        this._deleteButton.setFont(new Font("SansSerif", 0, 10));
        this._deleteButton.setMnemonic('d');
        this._deleteButton.setHorizontalTextPosition(0);
        this._deleteButton.setVerticalTextPosition(3);
        this._toolbar.add(this._deleteButton);
        this.add((Component)this._toolbar, "North");
        this._timeLogEntryTable.setModel(this._timeLogEntryTableModel);
        this._timeLogEntryTable.setSelectionModel(this._selectionModel);
        this._scrollPane.setViewportView(this._timeLogEntryTable);
        this.add((Component)this._scrollPane, "Center");
    }

    private void updateButtons() {
        this._deleteButton.setEnabled(this._deleteButton.getAction().isEnabled());
    }

    private void addActionsToButtons() {
        this._deleteButton.setAction(new DeleteTimeLogEntryAction(this));
    }
}

