/*
 * Decompiled with CFR 0.152.
 */
package com.octagonsoftware.clockease;

import com.octagonsoftware.clockease.TimeLog;
import com.octagonsoftware.clockease.TimeTrackerFrame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class Main {
    private TimeLog _timeLog;
    private File _saveFile;
    private TimeTrackerFrame _frame;

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        Main main = new Main();
        try {
            main.go();
        }
        catch (Throwable t) {
            t.printStackTrace();
            JOptionPane.showMessageDialog(null, "A fatal error occurred: " + t + "\nSee console for details.", "Fatal error", 0);
            System.exit(1);
        }
    }

    public void go() {
        this._timeLog = new TimeLog();
        try {
            this._saveFile = this.getSaveFile();
            if (this._saveFile.exists()) {
                this._timeLog.load(this._saveFile);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this._frame, "Could not load from " + this._saveFile.getAbsolutePath() + ": " + e.getMessage() + "\n" + "Please delete the file and reload the application.", "Could not load", 0);
            System.exit(1);
        }
        this._timeLog.addListener(new TimeLog.Listener(){

            public void timeLogStructureChanged(TimeLog.TimeLogEvent evt) {
                Main.this.saveFile();
            }

            public void timeLogEntryNewOrChanged(TimeLog.TimeLogEvent evt) {
                Main.this.saveFile();
            }
        });
        this._frame = new TimeTrackerFrame();
        this._frame.setTimeLog(this._timeLog);
        this._frame.setSize(640, 480);
        this._frame.setLocationByPlatform(true);
        this._frame.setVisible(true);
        this._frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                Main.this.saveFile();
                System.exit(0);
            }
        });
    }

    private File getSaveFile() throws IOException {
        File homeDir = new File(System.getProperty("user.home"));
        File clockeaseDir = new File(homeDir, ".clockease");
        if (!clockeaseDir.exists()) {
            clockeaseDir.mkdirs();
        }
        File saveFile = new File(clockeaseDir, "clockease.xml");
        return saveFile;
    }

    private void saveFile() {
        try {
            this._timeLog.save(this._saveFile);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this._frame, "Warning: Could not save to " + this._saveFile.getAbsolutePath() + ": " + e.getMessage(), "Could not save", 2);
        }
    }
}

