/*
 * Decompiled with CFR 0.152.
 */
package com.octagonsoftware.clockease;

import com.octagonsoftware.clockease.TimeLog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ReportPanel
extends JPanel {
    private TimeLog _timeLog;
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private JTextField _fromDate;
    private JLabel _fromLabel;
    private JButton _generateButton;
    private JEditorPane _reportPane;
    private JTextField _toDate;
    private JLabel _toLabel;
    private JPanel _topPanel;
    private JScrollPane jScrollPane1;

    public ReportPanel() {
        this.initComponents();
        this.populateDefaults();
    }

    public void setTimeLog(TimeLog timeLog) {
        this._timeLog = timeLog;
    }

    private void initComponents() {
        this._topPanel = new JPanel();
        this._fromLabel = new JLabel();
        this._fromDate = new JTextField();
        this._toLabel = new JLabel();
        this._toDate = new JTextField();
        this._generateButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this._reportPane = new JEditorPane();
        this.setLayout(new BorderLayout());
        this._topPanel.setLayout(new GridBagLayout());
        this._topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._fromLabel.setText("From:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this._topPanel.add((Component)this._fromLabel, gridBagConstraints);
        this._fromDate.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this._topPanel.add((Component)this._fromDate, gridBagConstraints);
        this._toLabel.setText("To:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        this._topPanel.add((Component)this._toLabel, gridBagConstraints);
        this._toDate.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this._topPanel.add((Component)this._toDate, gridBagConstraints);
        this._generateButton.setFont(new Font("Dialog", 0, 12));
        this._generateButton.setMnemonic('g');
        this._generateButton.setText("Generate");
        this._generateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPanel.this._generateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        this._topPanel.add((Component)this._generateButton, gridBagConstraints);
        this.add((Component)this._topPanel, "North");
        this._reportPane.setEditable(false);
        this._reportPane.setContentType("text/html");
        this.jScrollPane1.setViewportView(this._reportPane);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void _generateButtonActionPerformed(ActionEvent evt) {
        this.generateReport();
    }

    private void populateDefaults() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        while (cal.get(7) != 1) {
            cal.add(5, -1);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        this._fromDate.setText(sdf.format(cal.getTime()));
        cal.add(5, 6);
        this._toDate.setText(sdf.format(cal.getTime()));
    }

    private void generateReport() {
        if (this._timeLog != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            Date from = null;
            try {
                from = sdf.parse(this._fromDate.getText());
            }
            catch (ParseException e) {
                this._fromDate.grabFocus();
                JOptionPane.showMessageDialog(this, "The 'from' date is not in the syntax yyyy-MM-dd.", "Invalid date", 0);
            }
            if (from != null) {
                Date to = null;
                try {
                    to = sdf.parse(this._toDate.getText());
                }
                catch (ParseException e) {
                    this._toDate.grabFocus();
                    JOptionPane.showMessageDialog(this, "The 'to' date is not in the syntax yyyy-MM-dd.", "Invalid date", 0);
                }
                if (to != null) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(from);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    from = cal.getTime();
                    cal.setTime(to);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    cal.add(5, 1);
                    to = cal.getTime();
                    String html = this._timeLog.generateHTMLReport(from, to);
                    this._reportPane.setText(html);
                }
            }
        }
    }
}

