/*
 * Decompiled with CFR 0.152.
 */
package com.octagonsoftware.clockease;

import com.octagonsoftware.clockease.ElapsedTime;
import com.octagonsoftware.clockease.Task;
import com.octagonsoftware.clockease.TimeLogEntry;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Stack;
import java.util.UUID;
import javax.swing.DefaultListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class TimeLog {
    private DefaultListModel _taskList;
    private DefaultListModel _timeLogEntries;
    private EventListenerList _listeners = new EventListenerList();
    private ListDataListener _listListener = new ListDataListener(){

        public void intervalAdded(ListDataEvent e) {
            TimeLog.this.fireTimeLogStructureChanged();
        }

        public void intervalRemoved(ListDataEvent e) {
            TimeLog.this.fireTimeLogStructureChanged();
        }

        public void contentsChanged(ListDataEvent e) {
            TimeLog.this.fireTimeLogStructureChanged();
        }
    };

    public TimeLog() {
        this.setTaskList(new DefaultListModel());
        this.setTimeLogEntries(new DefaultListModel());
    }

    public DefaultListModel getTaskList() {
        return this._taskList;
    }

    public DefaultListModel getTimeLogEntries() {
        return this._timeLogEntries;
    }

    public int taskListIndexForId(UUID id) {
        int result = -1;
        Enumeration iter = this._taskList.elements();
        int i = 0;
        while (iter.hasMoreElements()) {
            Task task = (Task)iter.nextElement();
            if (task.getId().equals(id)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public Task taskForId(UUID taskId) {
        Task result = null;
        int index = this.taskListIndexForId(taskId);
        if (index != -1) {
            result = (Task)this._taskList.get(index);
        }
        return result;
    }

    public ElapsedTime totalTimeForTask(UUID taskId) {
        int millis = 0;
        Enumeration iter = this._timeLogEntries.elements();
        while (iter.hasMoreElements()) {
            TimeLogEntry entry = (TimeLogEntry)iter.nextElement();
            if (!entry.getTaskId().equals(taskId)) continue;
            Date startTime = entry.getStartTime();
            Date endTime = entry.getEndTime();
            if (endTime == null) {
                endTime = new Date();
            }
            millis += (int)(endTime.getTime() - startTime.getTime());
        }
        return new ElapsedTime(millis);
    }

    public ElapsedTime todayTimeForTask(UUID taskId, Date todayDate) {
        Calendar today = Calendar.getInstance();
        today.setTime(todayDate);
        today.set(11, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        long todayStart = today.getTimeInMillis();
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.setTime(today.getTime());
        tomorrow.add(5, 1);
        long todayEnd = tomorrow.getTimeInMillis();
        int millis = 0;
        Enumeration iter = this._timeLogEntries.elements();
        while (iter.hasMoreElements()) {
            TimeLogEntry entry = (TimeLogEntry)iter.nextElement();
            if (!entry.getTaskId().equals(taskId)) continue;
            Date startDate = entry.getStartTime();
            Date endDate = entry.getEndTime();
            if (endDate == null) {
                endDate = new Date();
            }
            long startTime = startDate.getTime();
            long endTime = endDate.getTime();
            if (endTime < todayStart || startTime >= todayEnd) continue;
            if (startTime < todayStart) {
                startTime = todayStart;
            }
            if (endTime > todayEnd) {
                endTime = todayEnd;
            }
            millis += (int)(endTime - startTime);
        }
        return new ElapsedTime(millis);
    }

    public void activateTask(UUID taskId) {
        TimeLogEntry entry;
        Date now = new Date();
        if (!this._timeLogEntries.isEmpty() && (entry = (TimeLogEntry)this._timeLogEntries.lastElement()).getEndTime() == null) {
            entry.setEndTime(now);
            this.fireTimeLogEntryNewOrChanged(entry, this._timeLogEntries.size() - 1);
        }
        if (taskId != null) {
            TimeLogEntry newEntry = new TimeLogEntry();
            newEntry.setTaskId(taskId);
            newEntry.setStartTime(now);
            newEntry.setEndTime(null);
            this._timeLogEntries.addElement(newEntry);
            this.fireTimeLogEntryNewOrChanged(newEntry, this._timeLogEntries.size() - 1);
        }
    }

    public void deleteTask(Task task) {
        UUID taskId = task.getId();
        Enumeration iter = this._taskList.elements();
        int foundIndex = -1;
        int i = 0;
        while (iter.hasMoreElements()) {
            Task t = (Task)iter.nextElement();
            if (t.getId().equals(taskId)) {
                foundIndex = i;
                break;
            }
            ++i;
        }
        if (foundIndex != -1) {
            this._taskList.removeElementAt(foundIndex);
            Stack<Integer> toDelete = new Stack<Integer>();
            iter = this._timeLogEntries.elements();
            i = 0;
            while (iter.hasMoreElements()) {
                TimeLogEntry entry = (TimeLogEntry)iter.nextElement();
                if (entry.getTaskId().equals(taskId)) {
                    toDelete.push(i);
                }
                ++i;
            }
            while (!toDelete.isEmpty()) {
                this._timeLogEntries.removeElementAt((Integer)toDelete.pop());
            }
            this.fireTimeLogStructureChanged();
        }
    }

    public UUID getActiveTaskId() {
        TimeLogEntry entry;
        UUID result = null;
        if (!this._timeLogEntries.isEmpty() && (entry = (TimeLogEntry)this._timeLogEntries.lastElement()).getEndTime() == null) {
            result = entry.getTaskId();
        }
        return result;
    }

    public void moveTaskAtIndexDown(int selectedIndex) {
        int count = this._taskList.size();
        if (selectedIndex != -1 && selectedIndex < count - 1) {
            Task firstTask = (Task)this._taskList.elementAt(selectedIndex);
            Task secondTask = (Task)this._taskList.elementAt(selectedIndex + 1);
            this._taskList.setElementAt(firstTask, selectedIndex + 1);
            this._taskList.setElementAt(secondTask, selectedIndex);
            this.fireTimeLogStructureChanged();
        }
    }

    public void moveTaskAtIndexUp(int selectedIndex) {
        if (selectedIndex > 0) {
            Task firstTask = (Task)this._taskList.elementAt(selectedIndex - 1);
            Task secondTask = (Task)this._taskList.elementAt(selectedIndex);
            this._taskList.setElementAt(firstTask, selectedIndex);
            this._taskList.setElementAt(secondTask, selectedIndex - 1);
            this.fireTimeLogStructureChanged();
        }
    }

    public String generateHTMLReport(Date from, Date to) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(to);
        cal.add(5, -1);
        Date toMinusOneDay = cal.getTime();
        StringBuffer result = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("E, yyyy-MM-dd");
        sdf.format(from);
        result.append(String.format("<h1>Daily tasks from %s to %s</h1>", sdf.format(from), sdf.format(toMinusOneDay))).append('\n');
        cal.setTime(from);
        result.append("<hr><h2>Task Notes</h2>\n");
        Enumeration iter = this._taskList.elements();
        while (iter.hasMoreElements()) {
            Task task = (Task)iter.nextElement();
            String logNotes = task.getLogText();
            if (logNotes == null || logNotes.trim().equals("")) continue;
            result.append(String.format("<h3>%s</h3>\n", task.getTitle()));
            result.append(String.format("<blockquote><pre>%s</pre></blockquote>", logNotes));
        }
        result.append("<hr><h2>Time Breakdown</h2>\n");
        do {
            ElapsedTime time;
            Task task;
            iter = this._taskList.elements();
            HashMap<String, ElapsedTime> breakdown = new HashMap<String, ElapsedTime>();
            int totalTime = 0;
            while (iter.hasMoreElements()) {
                task = (Task)iter.nextElement();
                time = this.todayTimeForTask(task.getId(), cal.getTime());
                if (time.getMillis() == 0) continue;
                breakdown.put(task.getTitle(), time);
                totalTime += time.getMillis();
            }
            if (!breakdown.isEmpty()) {
                result.append(String.format("<h3>%s</h3><blockquote>", sdf.format(cal.getTime()))).append('\n');
                result.append("<table border=\"1\">");
                result.append("<tr><td><b>Task</b></td><td><b>Elapsed Time</b></td><td><b>Percent</b></td></tr>");
                iter = this._taskList.elements();
                while (iter.hasMoreElements()) {
                    task = (Task)iter.nextElement();
                    time = (ElapsedTime)breakdown.get(task.getTitle());
                    if (time == null) continue;
                    result.append("<tr>");
                    result.append("<td>");
                    result.append(task.getTitle());
                    result.append("</td>");
                    result.append("<td>");
                    result.append(time.getAsHHMMSS());
                    result.append("</td>");
                    result.append("<td>");
                    int percent = 0;
                    if (totalTime > 0) {
                        percent = (int)Math.round(100.0 * (double)time.getMillis() / (double)totalTime);
                    }
                    result.append(percent).append('%');
                    result.append("</td>");
                    result.append("</tr>");
                }
                result.append("</table>");
                result.append("Total time: " + new ElapsedTime(totalTime).getAsHHMMSS());
                result.append("</blockquote>");
            }
            cal.add(5, 1);
        } while (cal.getTime().getTime() < to.getTime());
        return result.toString();
    }

    public void taskListUpdated() {
        this.fireTimeLogStructureChanged();
    }

    public TimeLogEntry getActiveTimeLogEntry() {
        TimeLogEntry entry;
        TimeLogEntry result = null;
        if (!this._timeLogEntries.isEmpty() && (entry = (TimeLogEntry)this._timeLogEntries.lastElement()).getEndTime() == null) {
            result = entry;
        }
        return result;
    }

    public void timeLogEntryNewOrChanged(TimeLogEntry entry, int index) {
        this.fireTimeLogEntryNewOrChanged(entry, index);
    }

    public void save(File f) throws IOException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("clockease");
            doc.appendChild(root);
            this.persistTaskList(doc, root);
            this.persistTimeLogEntries(doc, root);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(doc), new StreamResult(f));
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void persistTaskList(Document doc, Element root) {
        Element tasksElement = doc.createElement("tasks");
        root.appendChild(tasksElement);
        Enumeration iter = this._taskList.elements();
        while (iter.hasMoreElements()) {
            Task task = (Task)iter.nextElement();
            Element taskElement = doc.createElement("task");
            tasksElement.appendChild(taskElement);
            this.xmlAddElement(doc, taskElement, "id", task.getId().toString());
            this.xmlAddElement(doc, taskElement, "title", task.getTitle());
            this.xmlAddElement(doc, taskElement, "log-text", task.getLogText());
        }
    }

    private void persistTimeLogEntries(Document doc, Element root) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd HH:mm:ss.SSS");
        Element logEntriesElement = doc.createElement("log-entries");
        root.appendChild(logEntriesElement);
        Enumeration iter = this._timeLogEntries.elements();
        while (iter.hasMoreElements()) {
            Date endTime;
            TimeLogEntry entry = (TimeLogEntry)iter.nextElement();
            Element entryElement = doc.createElement("entry");
            logEntriesElement.appendChild(entryElement);
            this.xmlAddElement(doc, entryElement, "task-id", entry.getTaskId().toString());
            Date startTime = entry.getStartTime();
            if (startTime != null) {
                this.xmlAddElement(doc, entryElement, "start", sdf.format(startTime));
            }
            if ((endTime = entry.getEndTime()) == null) continue;
            this.xmlAddElement(doc, entryElement, "end", sdf.format(endTime));
        }
    }

    private void xmlAddElement(Document doc, Element root, String key, String value) {
        if (value != null) {
            Element keyElement = doc.createElement(key);
            keyElement.appendChild(doc.createTextNode(value));
            root.appendChild(keyElement);
        }
    }

    public void load(File f) throws IOException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(f);
            Element root = doc.getDocumentElement();
            DefaultListModel taskList = this.parseTaskList(root);
            DefaultListModel timeLogEntries = this.parseTimeLogEntries(root);
            this.setTaskList(taskList);
            this.setTimeLogEntries(timeLogEntries);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private DefaultListModel parseTaskList(Element root) {
        DefaultListModel<Task> result = new DefaultListModel<Task>();
        Element tasksElement = this.xmlFindFirstElementByName(root, "tasks");
        NodeList nodeList = tasksElement.getElementsByTagName("task");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Task task = new Task();
            Element taskElement = (Element)nodeList.item(i);
            task.setId(UUID.fromString(this.xmlFindValueForTag(taskElement, "id")));
            task.setTitle(this.xmlFindValueForTag(taskElement, "title"));
            task.setLogText(this.xmlFindValueForTag(taskElement, "log-text"));
            result.addElement(task);
        }
        return result;
    }

    private DefaultListModel parseTimeLogEntries(Element root) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd HH:mm:ss.SSS");
        DefaultListModel<TimeLogEntry> result = new DefaultListModel<TimeLogEntry>();
        Element logEntriesElement = this.xmlFindFirstElementByName(root, "log-entries");
        NodeList nodeList = logEntriesElement.getElementsByTagName("entry");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String endTime;
            TimeLogEntry entry = new TimeLogEntry();
            Element entryElement = (Element)nodeList.item(i);
            entry.setTaskId(UUID.fromString(this.xmlFindValueForTag(entryElement, "task-id")));
            String startTime = this.xmlFindValueForTag(entryElement, "start");
            if (startTime != null) {
                try {
                    entry.setStartTime(sdf.parse(startTime));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Error parsing time " + startTime);
                }
            }
            if ((endTime = this.xmlFindValueForTag(entryElement, "end")) != null) {
                try {
                    entry.setEndTime(sdf.parse(endTime));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Error parsing time " + endTime);
                }
            }
            result.addElement(entry);
        }
        return result;
    }

    private Element xmlFindFirstElementByName(Element root, String name) {
        return (Element)root.getElementsByTagName(name).item(0);
    }

    private String xmlFindValueForTag(Element root, String tagName) {
        Text text;
        String result = null;
        Element element = this.xmlFindFirstElementByName(root, tagName);
        if (element != null && (text = (Text)element.getFirstChild()) != null) {
            result = text.getData();
        }
        return result;
    }

    public void addListener(Listener listener) {
        this._listeners.add(Listener.class, listener);
    }

    public void removeListener(Listener listener) {
        this._listeners.remove(Listener.class, listener);
    }

    private void fireTimeLogStructureChanged() {
        Listener[] listeners;
        TimeLogEvent evt = new TimeLogEvent(this);
        for (Listener listener : listeners = (Listener[])this._listeners.getListeners(Listener.class)) {
            listener.timeLogStructureChanged(evt);
        }
    }

    private void fireTimeLogEntryNewOrChanged(TimeLogEntry entry, int entryIndex) {
        Listener[] listeners;
        TimeLogEvent evt = new TimeLogEvent(this, entry, entryIndex);
        for (Listener listener : listeners = (Listener[])this._listeners.getListeners(Listener.class)) {
            listener.timeLogEntryNewOrChanged(evt);
        }
    }

    private void setTaskList(DefaultListModel taskList) {
        if (this._taskList != null) {
            this._taskList.removeListDataListener(this._listListener);
        }
        this._taskList = taskList;
        this._taskList.addListDataListener(this._listListener);
    }

    private void setTimeLogEntries(DefaultListModel entryList) {
        if (this._timeLogEntries != null) {
            this._timeLogEntries.removeListDataListener(this._listListener);
        }
        this._timeLogEntries = entryList;
        this._timeLogEntries.addListDataListener(this._listListener);
    }

    public static class TimeLogEvent
    extends EventObject {
        private TimeLogEntry _entry;
        private int _entryIndex;

        public TimeLogEvent(TimeLog source) {
            this(source, null, -1);
        }

        public TimeLogEvent(TimeLog source, TimeLogEntry entry, int entryIndex) {
            super(source);
            this.setEntry(entry);
            this.setEntryIndex(entryIndex);
        }

        public TimeLogEntry getEntry() {
            return this._entry;
        }

        public void setEntry(TimeLogEntry entry) {
            this._entry = entry;
        }

        public int getEntryIndex() {
            return this._entryIndex;
        }

        public void setEntryIndex(int entryIndex) {
            this._entryIndex = entryIndex;
        }
    }

    public static interface Listener
    extends EventListener {
        public void timeLogStructureChanged(TimeLogEvent var1);

        public void timeLogEntryNewOrChanged(TimeLogEvent var1);
    }
}

