/*
 * Decompiled with CFR 0.152.
 */
package com.octagonsoftware.clockease;

import com.octagonsoftware.clockease.ElapsedTime;
import com.octagonsoftware.clockease.Task;
import com.octagonsoftware.clockease.TimeLog;
import com.octagonsoftware.clockease.TimeLogEntry;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLogEntryTableModel
implements TableModel,
TimeLog.Listener {
    private TimeLog _timeLog;
    private static final String[] COLUMNS = new String[]{"Start Time", "End Time", "Elapsed", "Task name"};
    private static final int COLUMN_START = 0;
    private static final int COLUMN_END = 1;
    private static final int COLUMN_ELAPSED = 2;
    private static final int COLUMN_TASK_NAME = 3;
    private EventListenerList _listeners = new EventListenerList();
    private ScheduledExecutorService _updateTimer = Executors.newScheduledThreadPool(1);

    public TimeLogEntryTableModel() {
        this._updateTimer.scheduleAtFixedRate(new Runnable(){

            public void run() {
                TimeLogEntryTableModel.this.updateActiveRow();
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    public void setTimeLog(TimeLog timeLog) {
        if (this._timeLog != null) {
            this._timeLog.removeListener(this);
        }
        this._timeLog = timeLog;
        this._timeLog.addListener(this);
        this.timeLogStructureChanged(new TimeLog.TimeLogEvent(this._timeLog));
    }

    @Override
    public int getRowCount() {
        return this._timeLog == null ? 0 : this._timeLog.getTimeLogEntries().size();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0 || columnIndex == 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String result = null;
        if (this._timeLog != null) {
            TimeLogEntry entry = (TimeLogEntry)this._timeLog.getTimeLogEntries().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    result = sdf.format(entry.getStartTime());
                    break;
                }
                case 1: {
                    Date endTime = entry.getEndTime();
                    if (endTime != null) {
                        result = sdf.format(endTime);
                        break;
                    }
                    result = "";
                    break;
                }
                case 2: {
                    ElapsedTime elapsed = new ElapsedTime(entry.getStartTime(), entry.getEndTime());
                    result = elapsed.getAsHHMMSS();
                    break;
                }
                case 3: {
                    UUID taskId = entry.getTaskId();
                    Task task = this._timeLog.taskForId(taskId);
                    result = task.getTitle();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown column id" + columnIndex);
                }
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String value = (String)aValue;
        if (this._timeLog != null) {
            TimeLogEntry entry = (TimeLogEntry)this._timeLog.getTimeLogEntries().get(rowIndex);
            switch (columnIndex) {
                case 0: 
                case 1: {
                    try {
                        Date parsed = null;
                        if (!value.trim().equals("")) {
                            parsed = this.parseTime(value);
                        }
                        if (columnIndex == 0) {
                            if (parsed == null) {
                                JOptionPane.showMessageDialog(null, "Start time cannot be empty.", "Invalid time", 0);
                            } else {
                                Date endTime = entry.getEndTime();
                                if (endTime == null) {
                                    endTime = new Date();
                                }
                                long endTimeMillis = endTime.getTime();
                                if (parsed.getTime() > endTimeMillis) {
                                    JOptionPane.showMessageDialog(null, "Start time cannot be after end time.", "Invalid time", 0);
                                } else {
                                    entry.setStartTime(parsed);
                                }
                            }
                        } else if (parsed != null) {
                            Date startTime = entry.getStartTime();
                            long startTimeMillis = startTime.getTime();
                            if (parsed.getTime() < startTimeMillis) {
                                JOptionPane.showMessageDialog(null, "End time cannot be before start time.", "Invalid time", 0);
                            } else {
                                entry.setEndTime(parsed);
                            }
                        } else if (rowIndex != this._timeLog.getTimeLogEntries().size() - 1) {
                            JOptionPane.showMessageDialog(null, "Only the last task in the log can be active.", "Invalid time", 0);
                        } else {
                            entry.setEndTime(null);
                        }
                        this._timeLog.timeLogEntryNewOrChanged(entry, rowIndex);
                    }
                    catch (ParseException e) {}
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown or uneditable column id" + columnIndex);
                }
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this._listeners.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this._listeners.remove(TableModelListener.class, l);
    }

    @Override
    public void timeLogStructureChanged(TimeLog.TimeLogEvent evt) {
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void timeLogEntryNewOrChanged(TimeLog.TimeLogEvent evt) {
        this.fireTableChanged(new TableModelEvent(this));
    }

    private void fireTableChanged(TableModelEvent evt) {
        TableModelListener[] listeners;
        for (TableModelListener listener : listeners = (TableModelListener[])this._listeners.getListeners(TableModelListener.class)) {
            listener.tableChanged(evt);
        }
    }

    private void updateActiveRow() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int row;
                UUID activeId;
                if (TimeLogEntryTableModel.this._timeLog != null && (activeId = TimeLogEntryTableModel.this._timeLog.getActiveTaskId()) != null && (row = TimeLogEntryTableModel.this._timeLog.getTimeLogEntries().size() - 1) != -1) {
                    TimeLogEntryTableModel.this.fireTableChanged(new TableModelEvent(TimeLogEntryTableModel.this, row));
                }
            }
        });
    }

    private Date parseTime(String value) throws ParseException {
        Date result = null;
        String[] acceptableFormats = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd hh:mm a", "yyyy-MM-dd HH:mm"};
        boolean triedWithPrependedDate = false;
        while (true) {
            for (String format : acceptableFormats) {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                try {
                    result = sdf.parse(value);
                    break;
                }
                catch (ParseException e) {
                }
            }
            if (result != null || triedWithPrependedDate) break;
            SimpleDateFormat justDate = new SimpleDateFormat("yyyy-MM-dd");
            value = justDate.format(new Date()) + " " + value;
            triedWithPrependedDate = true;
        }
        if (result == null) {
            StringBuffer formats = new StringBuffer();
            for (String format : acceptableFormats) {
                formats.append(format).append('\n');
            }
            JOptionPane.showMessageDialog(null, "Could not parse " + value + " as a time.\nPlease use one of the following formats:\n" + formats, "Cannot parse time", 0);
            throw new ParseException("Could not parse in any known format", 0);
        }
        return result;
    }
}

