/*
 * Decompiled with CFR 0.152.
 */
package com.octagonsoftware.clockease;

import com.octagonsoftware.clockease.DeleteTaskAction;
import com.octagonsoftware.clockease.MoveTaskDownAction;
import com.octagonsoftware.clockease.MoveTaskUpAction;
import com.octagonsoftware.clockease.NewTaskAction;
import com.octagonsoftware.clockease.Task;
import com.octagonsoftware.clockease.TimeLog;
import com.octagonsoftware.clockease.TimeTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;

public class TimeTrackerPanel
extends JPanel
implements ListSelectionListener {
    private TimeLog _timeLog;
    private TimeTableModel _timeTableModel;
    private DefaultListSelectionModel _selectionModel;
    private int _previousSelectedRow = -1;
    private EventListenerList _listeners = new EventListenerList();
    private JButton _deleteButton;
    private JButton _downButton;
    private JTextPane _logEntryNotesTextPane;
    private JButton _newButton;
    private JScrollPane _scrollPanel;
    private JScrollPane _scrollPanelForLogEntryNotes;
    private JLabel _spacer;
    private JSplitPane _splitPane;
    private JTable _timeTrackerTable;
    private JLabel _titleForTextBox;
    private JToolBar _toolbar;
    private JButton _upButton;
    private JPanel jPanel1;

    public TimeTrackerPanel() {
        this._timeTableModel = new TimeTableModel();
        this._selectionModel = new DefaultListSelectionModel();
        this._selectionModel.setSelectionMode(0);
        this.initComponents();
        this._timeTrackerTable.getSelectionModel().addListSelectionListener(this);
        TableColumnModel columnModel = this._timeTrackerTable.getColumnModel();
        this._timeTrackerTable.setAutoResizeMode(3);
        columnModel.getColumn(0).setMaxWidth(64);
        columnModel.getColumn(1).setMaxWidth(256);
        columnModel.getColumn(2).setMaxWidth(256);
        this.addActionsToButtons();
        this.updateControls();
    }

    public void setTimeLog(TimeLog timeLog) {
        this._timeLog = timeLog;
        this._timeTableModel.setTimeLog(timeLog);
    }

    public TimeLog getTimeLog() {
        return this._timeLog;
    }

    private void initComponents() {
        this._toolbar = new JToolBar();
        this._newButton = new JButton();
        this._deleteButton = new JButton();
        this._spacer = new JLabel();
        this._upButton = new JButton();
        this._downButton = new JButton();
        this._splitPane = new JSplitPane();
        this._scrollPanel = new JScrollPane();
        this._timeTrackerTable = new JTable();
        this.jPanel1 = new JPanel();
        this._titleForTextBox = new JLabel();
        this._scrollPanelForLogEntryNotes = new JScrollPane();
        this._logEntryNotesTextPane = new JTextPane();
        this.setLayout(new BorderLayout());
        this._toolbar.setFloatable(false);
        this._toolbar.setRollover(true);
        this._toolbar.setMaximumSize(new Dimension(57, 64));
        this._toolbar.setMinimumSize(new Dimension(57, 64));
        this._newButton.setFont(new Font("SansSerif", 0, 10));
        this._newButton.setMnemonic('n');
        this._newButton.setHorizontalTextPosition(0);
        this._newButton.setVerticalTextPosition(3);
        this._toolbar.add(this._newButton);
        this._deleteButton.setFont(new Font("SansSerif", 0, 10));
        this._deleteButton.setMnemonic('d');
        this._deleteButton.setHorizontalTextPosition(0);
        this._deleteButton.setVerticalTextPosition(3);
        this._toolbar.add(this._deleteButton);
        this._spacer.setText(" ");
        this._toolbar.add(this._spacer);
        this._upButton.setFont(new Font("SansSerif", 0, 10));
        this._upButton.setMnemonic('u');
        this._upButton.setHorizontalTextPosition(0);
        this._upButton.setVerticalTextPosition(3);
        this._toolbar.add(this._upButton);
        this._downButton.setFont(new Font("SansSerif", 0, 10));
        this._downButton.setMnemonic('w');
        this._downButton.setHorizontalTextPosition(0);
        this._downButton.setVerticalTextPosition(3);
        this._toolbar.add(this._downButton);
        this.add((Component)this._toolbar, "North");
        this._splitPane.setDividerLocation(250);
        this._splitPane.setOrientation(0);
        this._timeTrackerTable.setModel(this._timeTableModel);
        this._timeTrackerTable.setSelectionModel(this._selectionModel);
        this._scrollPanel.setViewportView(this._timeTrackerTable);
        this._splitPane.setLeftComponent(this._scrollPanel);
        this.jPanel1.setLayout(new BorderLayout());
        this._titleForTextBox.setFont(new Font("SansSerif", 0, 12));
        this._titleForTextBox.setText("Log entry notes for selected task:");
        this.jPanel1.add((Component)this._titleForTextBox, "North");
        this._scrollPanelForLogEntryNotes.setViewportView(this._logEntryNotesTextPane);
        this.jPanel1.add((Component)this._scrollPanelForLogEntryNotes, "Center");
        this._splitPane.setRightComponent(this.jPanel1);
        this.add((Component)this._splitPane, "Center");
    }

    public void valueChanged(ListSelectionEvent e) {
        ListSelectionListener[] listeners;
        for (ListSelectionListener listener : listeners = (ListSelectionListener[])this._listeners.getListeners(ListSelectionListener.class)) {
            listener.valueChanged(e);
        }
        this.updateControls();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this._listeners.add(ListSelectionListener.class, listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this._listeners.remove(ListSelectionListener.class, listener);
    }

    public int getSelectedRowIndex() {
        return this._timeTrackerTable.getSelectedRow();
    }

    public Task getSelectedTask() {
        Task result = null;
        int selectedRowIndex = this.getSelectedRowIndex();
        if (selectedRowIndex != -1) {
            result = (Task)this._timeLog.getTaskList().elementAt(selectedRowIndex);
        }
        return result;
    }

    public void clearSelection() {
        this._timeTrackerTable.clearSelection();
    }

    public int getRowCount() {
        return this._timeTrackerTable.getRowCount();
    }

    public void setSelectedRowIndex(int i) {
        this._timeTrackerTable.getSelectionModel().setSelectionInterval(i, i);
    }

    private void updateControls() {
        this._newButton.setEnabled(this._newButton.getAction().isEnabled());
        this._deleteButton.setEnabled(this._deleteButton.getAction().isEnabled());
        this._upButton.setEnabled(this._upButton.getAction().isEnabled());
        this._downButton.setEnabled(this._downButton.getAction().isEnabled());
        this.updateLogEntryTextBox();
    }

    private void updateLogEntryTextBox() {
        int selectedRow = this._timeTrackerTable.getSelectedRow();
        if (selectedRow != this._previousSelectedRow && this._previousSelectedRow != -1) {
            String newText = this._logEntryNotesTextPane.getText();
            Task task = (Task)this._timeLog.getTaskList().elementAt(this._previousSelectedRow);
            if (task != null && !newText.equals(task.getLogText())) {
                task.setLogText(newText);
            }
        }
        if (selectedRow == -1) {
            this._logEntryNotesTextPane.setText("");
            this._logEntryNotesTextPane.setEnabled(false);
            this._titleForTextBox.setEnabled(false);
        } else {
            Task task = (Task)this._timeLog.getTaskList().elementAt(selectedRow);
            this._logEntryNotesTextPane.setText(task.getLogText());
            this._logEntryNotesTextPane.setEnabled(true);
            this._titleForTextBox.setEnabled(true);
        }
        this._previousSelectedRow = selectedRow;
    }

    private void addActionsToButtons() {
        this._newButton.setAction(new NewTaskAction(this));
        this._deleteButton.setAction(new DeleteTaskAction(this));
        this._upButton.setAction(new MoveTaskUpAction(this));
        this._downButton.setAction(new MoveTaskDownAction(this));
    }
}

