/*
 * Decompiled with CFR 0.152.
 */
package com.octagonsoftware.clockease;

import com.octagonsoftware.clockease.DeleteTaskAction;
import com.octagonsoftware.clockease.TimeLog;
import com.octagonsoftware.clockease.TimeLogEntry;
import com.octagonsoftware.clockease.TimeLogEntryPanel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class DeleteTimeLogEntryAction
extends AbstractAction {
    private TimeLogEntryPanel _panel;

    public DeleteTimeLogEntryAction(TimeLogEntryPanel panel) {
        super("Delete Entry", new ImageIcon(DeleteTaskAction.class.getResource("/com/octagonsoftware/clockease/images/deletetimelogentry.png")));
        this._panel = panel;
    }

    public void actionPerformed(ActionEvent e) {
        int selectedIndex = this._panel.getSelectedIndex();
        if (selectedIndex != -1) {
            TimeLogEntry entry;
            TimeLog timeLog = this._panel.getTimeLog();
            String title = timeLog.taskForId((entry = (TimeLogEntry)timeLog.getTimeLogEntries().elementAt(selectedIndex)).getTaskId()).getTitle();
            if (title == null) {
                title = "";
            }
            if (JOptionPane.showConfirmDialog(this._panel, String.format("Are you sure you wish to delete this time log entry for task '%s'?", title), "Confirm Delete Log Entry", 0, 3) == 0) {
                this._panel.clearSelection();
                timeLog.getTimeLogEntries().removeElementAt(selectedIndex);
            }
        }
    }

    public boolean isEnabled() {
        return this._panel.getSelectedIndex() != -1;
    }
}

