/*
 * Decompiled with CFR 0.152.
 */
package com.octagonsoftware.clockease;

import com.octagonsoftware.clockease.Task;
import com.octagonsoftware.clockease.TimeLog;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeTableModel
implements TableModel,
TimeLog.Listener {
    private TimeLog _timeLog;
    private static final String[] COLUMNS = new String[]{"Active", "Total", "Today", "Task name"};
    private static final int COLUMN_ACTIVE = 0;
    private static final int COLUMN_TOTAL = 1;
    private static final int COLUMN_TODAY = 2;
    private static final int COLUMN_TASK = 3;
    private EventListenerList _listeners = new EventListenerList();
    private ScheduledExecutorService _updateTimer = Executors.newScheduledThreadPool(1);
    private Date _previousUpdateTime = null;

    public TimeTableModel() {
        this._updateTimer.scheduleAtFixedRate(new Runnable(){

            public void run() {
                TimeTableModel.this.updateActiveRow();
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    public void setTimeLog(TimeLog timeLog) {
        if (this._timeLog != null) {
            this._timeLog.removeListener(this);
        }
        this._timeLog = timeLog;
        this._timeLog.addListener(this);
        this.timeLogStructureChanged(new TimeLog.TimeLogEvent(this._timeLog));
    }

    @Override
    public int getRowCount() {
        return this._timeLog == null ? 0 : this._timeLog.getTaskList().size();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 0 ? Boolean.class : String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0 || columnIndex == 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        if (this._timeLog != null) {
            Task task = (Task)this._timeLog.getTaskList().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    result = task.getId().equals(this._timeLog.getActiveTaskId());
                    break;
                }
                case 1: {
                    result = this._timeLog.totalTimeForTask(task.getId()).getAsHHMMSS();
                    break;
                }
                case 2: {
                    result = this._timeLog.todayTimeForTask(task.getId(), new Date()).getAsHHMMSS();
                    break;
                }
                case 3: {
                    result = task.getTitle();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown column id" + columnIndex);
                }
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this._timeLog != null) {
            Task task = (Task)this._timeLog.getTaskList().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    if (task.getId().equals(this._timeLog.getActiveTaskId())) {
                        this._timeLog.activateTask(null);
                        break;
                    }
                    this._timeLog.activateTask(task.getId());
                    break;
                }
                case 3: {
                    task.setTitle(aValue.toString());
                    this._timeLog.taskListUpdated();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown or uneditable column id" + columnIndex);
                }
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this._listeners.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this._listeners.remove(TableModelListener.class, l);
    }

    @Override
    public void timeLogStructureChanged(TimeLog.TimeLogEvent evt) {
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void timeLogEntryNewOrChanged(TimeLog.TimeLogEvent evt) {
        int row = this._timeLog.taskListIndexForId(evt.getEntry().getTaskId());
        this.fireTableChanged(new TableModelEvent(this, row));
    }

    private void fireTableChanged(TableModelEvent evt) {
        TableModelListener[] listeners;
        for (TableModelListener listener : listeners = (TableModelListener[])this._listeners.getListeners(TableModelListener.class)) {
            listener.tableChanged(evt);
        }
    }

    private void updateActiveRow() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (TimeTableModel.this._timeLog != null) {
                    int row;
                    Date now = new Date();
                    UUID activeId = TimeTableModel.this._timeLog.getActiveTaskId();
                    if (activeId != null && (row = TimeTableModel.this._timeLog.taskListIndexForId(activeId)) != -1) {
                        TimeTableModel.this.fireTableChanged(new TableModelEvent(TimeTableModel.this, row));
                    }
                    if (TimeTableModel.this._previousUpdateTime == null) {
                        TimeTableModel.this.fireTableChanged(new TableModelEvent(TimeTableModel.this));
                    } else {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(TimeTableModel.this._previousUpdateTime);
                        int prevYear = cal.get(1);
                        int prevMonth = cal.get(2);
                        int prevDay = cal.get(5);
                        cal.setTime(now);
                        int year = cal.get(1);
                        int month = cal.get(2);
                        int day = cal.get(5);
                        if (year != prevYear || month != prevMonth || day != prevDay) {
                            TimeTableModel.this.fireTableChanged(new TableModelEvent(TimeTableModel.this));
                        }
                    }
                    TimeTableModel.this._previousUpdateTime = now;
                }
            }
        });
    }
}

